#include <stdio.h>
#include "csapp.h"

/**
 * A quick demo showing how to use CSAPP functions.
 * Make sure you compile using the provided Makefile:
 *   $ make
 $   $ ./main
 **/

void* fn(void* args) {
  int* valptr = (int*) args;
  printf("Hello, I am thread %d.\n", *valptr);
  return 0;
}

void modifyit(int* x, int i) {
  *x = 23 + i*2;
}

int main() {
  int i, N = 10;
  pthread_t tids[N];
  printf("  Creating %d threads.\n", N);
  for (i=0; i<N; ++i) {
    Pthread_create(&tids[i], 0,
                   fn, &i);
  }
  printf("  Joining on %d threads...\n", N);
  for (i=0; i<N; ++i) {
    Pthread_join(tids[i], 0);
  }
  printf("Done.\n");
  return 0;
}
