#include <unistd.h>
#include <stdio.h>
#include <fcntl.h> // for flags

void chatterbot() {
  int N = 30;
  char buf[N];
  ssize_t nbytes;
  printf("Type things, press <ENTER>. Type 'q' to exit.\n");
  while (1) {
    nbytes = read(STDIN_FILENO, buf, N-1);
    if (nbytes == -1) {
      printf("nbytes is -1, exiting.\n");
      return;
    } else if (nbytes == 0) {
      printf("Reached EOF.\n");
      break;
    } else {
      printf("  Read in %d bytes.\n", (int) nbytes);
      buf[nbytes] = '\0';
      if (buf[0] == 'q') {
        printf("(chatterbot): Goodbye!\n");
        break;
      }
      printf("(chatterbot): %s\n", buf);
    }
  }
}

int main(int argc, char* argv[]) {
  chatterbot();
  printf("Exiting.\n");
  return 0;
}
