#include <unistd.h>
#include <stdio.h>
#include <fcntl.h> // for flags

/**
 * Display contents of file using POSIX functions.
 * USAGE:
 *   $ ./dispfile FILENAME
 **/
void display_file_posix(char* fname) {
  int fd = open(fname, O_RDONLY, 0);
  int N = 30;
  char buf[N];
  ssize_t nbytes;
  while (1) {
    nbytes = read(fd, buf, N-1);
    if (nbytes == -1) {
      printf("nbytes is -1, exiting.\n");
      return;
    } else if (nbytes == 0) {
      printf("Reached EOF.\n");
      break;
    } else {
      printf("  Read in %d bytes.\n", (int) nbytes);
      buf[nbytes] = '\0';
      printf("%s\n", buf);
    }
  }
}

int main(int argc, char* argv[]) {
  if (argc < 2) {
    printf("  Error - must pass in filename!\n");
    printf("Exiting.\n"); return 1;
  }
  char* fname = argv[1];
  printf("Printing out contents of file: %s\n", fname);
  display_file_posix(fname);
  printf("Exiting.\n");
  return 0;
}
