#include <iostream>
#include <vector>
#include <string>
using namespace std;

/**
 * Week 10b, exercise 1 (a-d).
 **/

class ShopCart {
public:
    ShopCart(); // Initialize with empty cart
    ShopCart(const vector<string>& items); // Initialize with given items
    void add(const string& item); // Adds item to the cart
    size_t size() const; // Returns number of items in cart
    string get_item(size_t i) const; // returns item at index i, or empty string "" if 
                                     // not valid index
private:
    vector<string> items;
};

ShopCart::ShopCart() : items() {}
/* Note that the following could have worked too:
    ShopCart::ShopCart() {} 
This works because "items" would be initialized by its default constructor. The default constructor of the vector class creates an empty vector object, which is exactly what we wanted. However, I think it's better style to use the former, since it's more explicit and potentially less confusing.
*/
ShopCart::ShopCart(const vector<string>& items) : items(items) {}
/* Passing a vector into a vector initializer copies the contents of the first vector into the second vector:
    vector<int> nums1 = {1, 2, 3};
    vector<int> nums2(nums1); // nums2 is: [1, 2, 3]
Alternately, if you did not know this, we could have done it the long way:
    ShopCart::ShopCart(const vector<string>& items) {
        for (string item : items) {
            this->items.push_back(item);
        }
    }
*/        
void ShopCart::add(const string& item) {
    this->items.push_back(item);
}
size_t ShopCart::size() const {
    return this->items.size();
}
string ShopCart::get_item(size_t i) const {
    if ((i < 0) || (i >= this->items.size())) {
        return "";
    }
    return this->items[i];
}

ShopCart& operator+=(ShopCart& left, const ShopCart& right) {
    for (size_t i = 0; i < right.size(); ++i) {
        left.add(right.get_item(i));
    }
    return left;
}
ostream& operator<<(ostream& os, const ShopCart& right) {
    os << "ShopCart(" << right.size() << ", {";
    for (size_t i = 0; i < right.size(); ++i) {
        os << "\"" << right.get_item(i) << "\", ";
    }
    os << "})";
    return os;
}
bool operator<(const ShopCart& left, const ShopCart& right) {
    return (left.size() < right.size());
}

int main() {
    ShopCart mycart;
    mycart.add("Scrubs Season 4");    mycart.add("Stuffed Dog");
    cout << mycart.size() << endl; // Outputs: 2

    ShopCart jdcart;    jdcart.add("Appletini");
    ShopCart janitorcart;    janitorcart.add("pager");
    jdcart += janitorcart;
    cout << jdcart.size() << endl; // Outputs: 2, stores: ["Appletini","pager"]
    cout << janitorcart.size() << endl; // Outputs: 1, stores: ["pager"]  

    vector<string> items = {"knifewrench", "mop"};
    ShopCart janitorcart2(items);
    cout << janitorcart2 << endl; // Displays: ShopCart(2, {"knifewrench", "mop"})

    ShopCart dr_reid;
    dr_reid.add("coffee"); dr_reid.add("clipboard");
    ShopCart turkleton;
    turkleton.add("pancake");
    if (turkleton < dr_reid) 
      cout << "Turk has fewer items than Dr. Reid" << endl;

    return 0;
}
