#include <iostream>
#include <string>
#include <vector>
using namespace std;

/**
 * Week 9a Notes Problem 2
 **/

/**
 * Finds the index of character c in the string s. Assumes that c is
 * present within s.
 **/
size_t find_char(const string& s, const char c) {
  for (size_t i = 0; i < s.size(); ++i) {
    if (s[i] == c) 
      return i;
  }
  return 0; // Not ideal, but we assume it always is found
}
/**
 * Given a name of the form "LASTNAME, FIRSTNAME", returns the first name.
 **/
string get_firstname(const string& name) {
  size_t comma_ind = find_char(name, ',');
  return name.substr(comma_ind+2);
}
/**
 * Given a vector of names of the form "LASTNAME, FIRSTNAME", displays
 * all of the first names.
 **/
void display_firstnames(const vector<string>& names) {
  for (string name : names)
    cout << get_firstname(name) << endl;
}    
int main() {
  /* Given a bunch of names of the form "LASTNAME, FIRSTNAME",
   * output the first names on each line. */
  vector<string> beatles = { "McCartney, Paul", "Harrison, George",
	"Lennon, John", "Starr, Ringo" };
  display_firstnames(beatles);
  vector<string> dudes = { "Chopin, Frederic", "Beethoven, Ludwig",
	"Liszt, Franz", "Barber, Samuel" };
  display_firstnames(dudes);
  return 0;
}

