function [u, cvx_optval, cvx_status] = l1_cvx(P, q)
%L1_CVX Solves the L1-minimization problem:
%    min || Pu + q ||_1
%with variable u.
%Uses CVX as a baseline.

m = size(P, 1);
n = size(P, 2);
cvx_begin quiet
    variable u(n)
    minimize( norm(P*u + q, 1) )
cvx_end

end
